package gov.va.vamf.scheduling.direct.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Document(collection="custom-friendly-text")
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(namespace = Namespace.VarUtility)
public class CustomFriendlyText extends DomainBaseObject {

    @XmlElement
    private String parentFacilityCode;

    @XmlElement
    private String siteCode;

    @XmlElement(nillable = true)
    @JsonInclude(JsonInclude.Include.ALWAYS)
    private String friendlyText;

    public String getSiteCode() {
        return siteCode;
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public String getFriendlyText() {
        return friendlyText;
    }

    public void setFriendlyText(String friendlyText) {
        this.friendlyText = friendlyText;
    }

    public String getParentFacilityCode() {
        return parentFacilityCode;
    }

    public void setParentFacilityCode(String parentFacilityCode) {
        this.parentFacilityCode = parentFacilityCode;
    }
}